string GetDescription()
{
	return "Renders the harmony into a boogie woogie syle accompaniament with a swing style rythm.";
}

void Render(RenderPart @p)
{
	Time t = CreateTime(p.GetStartBar(), 0);
	double delta;
	double[] delta_swing(8);
	
	if (p.GetTempo() > 90) delta = 0.5;
	else delta = 0.25;
	
	for (int i = 0; i < 8; i++)
		delta_swing[i] = delta;
		
	int[] vel = { 127, 118, 125, 115, 127, 115, 127, 127 };
		
	for (int i = 0; i < 8; i+=2)
	{
		if (RndInt(0,1) == 0) 
		{
			delta_swing[i] *= 1.5;
			delta_swing[i+1] *= 0.5;
		}
	}
	
	int[] scale = { 0, 7, 2, 3, 3, 4, -3, 4 };
	int[] diat_off = { 0, 0, 0, 0, 1, 0, 0, 0 };
	
	int note = 0;
	int old_nhp = -1;
	
	double len_mult = 1.0;
	if (RndInt(0,1) == 0) len_mult = 0.9;
		
	while (t.m_Bar < p.GetEndBar())
	{
		int nhp = p.GetHarmonicEventPitch(p.GetHarmonic(t),0);
		if (nhp != old_nhp)
		{
			note = 0;
			old_nhp = nhp;	
		}
		
		Time t2;
		t2.m_Bar = t.m_Bar;
		t2.m_Pos = t.m_Pos + delta_swing[note]*len_mult; 
		
		Log("note " + note + " start: "+ t.m_Bar +", "+t.m_Pos+" ( len = "+delta_swing[note]+ " )");
				
		
		p.AddNote(t, t2, p.AlignPitch(nhp, scale[note])+diat_off[note] , RndInt(vel[note]-5, vel[note]));	
				
		t.m_Pos += delta_swing[note];
		note = (note + 1) % 8;
				
		if (t.m_Pos >= p.GetUniquePart().GetMetrum())
		{
			t.m_Bar++;
			t.m_Pos = 0;	
			note = 0;
		}
	}
}
